/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.platform;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import net.impactdev.impactor.api.platform.PlatformComponent;
import net.impactdev.impactor.api.platform.PlatformInfo;
import net.impactdev.impactor.api.platform.PlatformType;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.core.platform.components.JDKPlatformComponent;

public abstract class ImpactorPlatformInfo
implements PlatformInfo {
    public static final String GIT_HASH = "@githash@";
    private final PlatformType type;
    private final Set<PlatformComponent> components;

    protected ImpactorPlatformInfo(PlatformType type) {
        this.type = type;
        this.components = this.generate();
    }

    @Override
    public PlatformType type() {
        return this.type;
    }

    @Override
    public Set<PlatformComponent> components() {
        return ImmutableSet.copyOf(this.components);
    }

    @Override
    public void print(PrettyPrinter printer) {
        printer.add("Platform: " + this.type.name().charAt(0) + this.type.name().substring(1).toUpperCase());
        printer.newline();
        this.printComponents(printer);
    }

    private Set<PlatformComponent> generate() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.add(new JDKPlatformComponent());
        this.specifyComponents(result);
        return result;
    }

    protected abstract void printComponents(PrettyPrinter var1);

    protected abstract void specifyComponents(Set<PlatformComponent> var1);
}

